<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Client;
use Google\Cloud\Firestore\FirestoreClient;

class AdminController extends Controller
{
    public function index(){
       // return view('awa.dashboard');
       $client = new Client([
        'base_uri' => config('services.admin_api.base_url'),
        'timeout'  => 5,
    ]);

    try {
      $response   = $client->get('/list_user_admin');
        $data       = json_decode($response->getBody(), true);
        $totalUsers = $data['total_users'] ?? 0;
    } catch (\Exception $e) {
        $totalUsers = 0;
    }


    try {
        $responseS      = $client->get('/list_speakers_admin');
        $dataS          = json_decode($responseS->getBody(), true);
        $totalSpeakers  = $dataS['total_speakers'] ?? 0;
    } catch (\Exception $e) {
        $totalSpeakers = 0;
    }


      // --- NEW: Firestore logic to count unique tickets (unique emails) ---
      try {
        
        $serviceAccount = base_path(env('FIREBASE_CREDENTIALS'));
        $projectId      = env('FIREBASE_PROJECT_ID');

        $fs = new FirestoreClient([
            'projectId'   => $projectId,
            'keyFilePath' => $serviceAccount,
           // 'transport'   => 'rest',  
        ]);

       
        $refs = $fs->collection('supportChats')->listDocuments();

        
        $totalTickets = 0;
        foreach ($refs as $_) {
            $totalTickets++;
        }
    } catch (\Exception $e) {
        $totalTickets = 0;
    }

    
    return view('awa.dashboard', [
        'totalUsers' => $totalUsers,
        'totalSpeakers' => $totalSpeakers,
        'totalTickets' => $totalTickets,
    ]);
}
    
}
