<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Client;

class AdminSettingsController extends Controller
{
    

    public function showTrialForm(Request $request)
    {
        
        return view('awa.pages.trial-settings', [
            'trial_enabled'  => old('trial_enabled', false),
            'trail_days'  => old('trail_days', 7),
        ]);
    }



    public function setTrial(Request $request)
    {
        $data = $request->validate([
            'trial_enabled' => 'required|string|in:true,false',
            'trail_days'  => 'required|string',
        ]);

      // dd($data);

        $client = new Client([
            'base_uri' => config('services.admin_api.base_url'),
            'timeout'  => 5,
        ]);

        

        try {

          
            $resp = $client->post('/admin_set_app_trial/', [
                'form_params' => [
                    'trial_enabled' => $data['trial_enabled'],
                    'trail_days' => $data['trail_days'],
                ],
            ]);

          

            $body = json_decode((string)$resp->getBody(), true);

         //   if (($body['status'] ?? 1) === 0) {
                return redirect()
                    ->route('admin.trial.form')
                    ->with('success', $body['message'] ?? 'Settings saved.');
         //   }

            return back()
                ->withErrors(['form' => $body['message'] ?? 'Unknown error'])
                ->withInput();

        } catch (\Exception $e) {
            return back()
                ->withErrors(['form' => 'Service unavailable.'])
                ->withInput();
        }
    }


}
