<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Client;
use Illuminate\Pagination\LengthAwarePaginator;

class AdminSpeakerController extends Controller
{
    public function index(Request $request)
    {
       
        $client = new Client([
            'base_uri' => config('services.admin_api.base_url'),
            'timeout'  => 5,
        ]);

        try {
            $response = $client->get('/list_speakers_admin');
            $data     = json_decode($response->getBody(), true);
            $allSpeakers = $data['speakers'] ?? [];
        } catch (\Exception $e) {
            $allSpeakers = [];
        }

       
        $perPage = 5;
        $page    = $request->get('page', 1);
        $collection = collect($allSpeakers);

        $currentPageItems = $collection
            ->slice(($page - 1) * $perPage, $perPage)
            ->values();

        $paginator = new LengthAwarePaginator(
            $currentPageItems,            
            $collection->count(),         
            $perPage,                     
            $page,                       
            [
                'path'  => $request->url(),   
                'query' => $request->query(),  
            ]
        );

       
        return view('awa.pages.speakers', [
            'speakers' => $paginator,
        ]);
    }
}
