@extends('layouts.auth') 

@section('content')
  <div class="row flex-grow">
    <div class="col-lg-4 mx-auto">
      <div class="auth-form-light text-left p-5">
        <div class="brand-logo">
          <img src="{{ asset('assets/images/awa.png') }}" alt="logo" />
        </div>
        @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show">
          {{ session('error') }}
          <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
      @endif
        <h4>Hello! let's get started</h4>
        <h6 class="font-weight-light">Sign in to continue.</h6>
        <form method="POST" action="{{ route('admin.login') }}" class="pt-3">
          @csrf
          <div class="form-group">
            <input name="name"
                   type="text"
                   class="form-control form-control-lg"
                   placeholder="Username">
          </div>
          <div class="form-group">
            <input name="email"
                   type="email"
                   class="form-control form-control-lg"
                   placeholder="Email">
          </div>
          <div class="form-group">
            <input name="password"
                   type="password"
                   class="form-control form-control-lg"
                   placeholder="Password">
          </div>
          <div class="mt-3 d-grid gap-2">
            <button type="submit"
                    class="btn btn-block btn-gradient-primary btn-lg font-weight-medium auth-form-btn">
              SIGN IN
            </button>
          </div> 
          <div class="my-2 d-flex justify-content-between align-items-center">
            <div class="form-check">
              <label class="form-check-label text-muted">
                <input name="remember" type="checkbox" class="form-check-input">
                Keep me signed in
              </label>
            </div>
            <a href=""
               class="auth-link text-primary">Forgot password?</a>
          </div>
          <div class="mb-2 d-grid gap-2">
            <a href="#" class="btn btn-block btn-facebook auth-form-btn">
              <i class="mdi mdi-facebook me-2"></i>Connect using Facebook
            </a>
          </div>
          <div class="text-center mt-4 font-weight-light">
            Don't have an account?
            <a href="" class="text-primary">Create</a>
          </div>
        </form>
      </div>
    </div>
  </div>

  <style>
    .auth .brand-logo img {
    width: 300px;
}



.btn-gradient-primary {
  background: linear-gradient(to right, #6ea8ff, #0041C2) !important;

}

.form-check .form-check-label input[type=checkbox] + .input-helper:before {
    
    border: solid #0041C2;

}

    </style>
@endsection
