@extends('layouts.app')

@section('content') 

<div class="page-header">
    <h3 class="page-title">
      <span class="page-title-icon bg-gradient-primary text-white me-2">
        <i class="mdi mdi-home"></i>
      </span>
      Dashboard
    </h3>
    <nav aria-label="breadcrumb">
      <ul class="breadcrumb">
        <li class="breadcrumb-item active" aria-current="page">
          <span></span>Overview
          <i class="mdi mdi-alert-circle-outline icon-sm text-primary align-middle"></i>
        </li>
      </ul>
    </nav>
  </div>
  <div class="row">
    <div class="col-md-4 stretch-card grid-margin">
      <div class="card bg-gradient-danger card-img-holder text-white">
        <div class="card-body">
          <img src="{{ asset('assets/images/dashboard/circle.svg') }}"
               class="card-img-absolute"
               alt="circle-image" />
          <h4 class="font-weight-normal mb-3">
            Total Users
            <i class="mdi mdi-chart-line mdi-24px float-end"></i>
          </h4>
          <h2 class="mb-5">{{ number_format($totalUsers) }}</h2>
          <h6 class="card-text">Increased by 60%</h6>
        </div>
      </div>
    </div>
    <div class="col-md-4 stretch-card grid-margin">
      <div class="card bg-gradient-info card-img-holder text-white">
        <div class="card-body">
          <img src="{{ asset('assets/images/dashboard/circle.svg') }}"
               class="card-img-absolute"
               alt="circle-image" />
          <h4 class="font-weight-normal mb-3">
            Total Speakers
            <i class="mdi mdi-bookmark-outline mdi-24px float-end"></i>
          </h4>
          <h2 class="mb-5">{{ number_format($totalSpeakers) }}</h2>
          <h6 class="card-text">Decreased by 10%</h6>
        </div>
      </div>
    </div>
    <div class="col-md-4 stretch-card grid-margin">
      <div class="card bg-gradient-success card-img-holder text-white">
        <div class="card-body">
          <img src="{{ asset('assets/images/dashboard/circle.svg') }}"
               class="card-img-absolute"
               alt="circle-image" />
          <h4 class="font-weight-normal mb-3">
            Total Tickets
            <i class="mdi mdi-diamond mdi-24px float-end"></i>
          </h4>
          <h2 class="mb-5">{{ number_format($totalTickets) }}</h2>
          <h6 class="card-text">Increased by 5%</h6>
        </div>
      </div>
    </div>
  </div>
  <div class="row">
    <div class="col-md-7 grid-margin stretch-card">
      <div class="card">
        <div class="card-body">
          <div class="clearfix">
            <h4 class="card-title float-start">Visit And Sales Statistics</h4>
            <div id="visit-sale-chart-legend"
                 class="rounded-legend legend-horizontal legend-top-right float-end">
            </div>
          </div>
          <canvas id="visit-sale-chart" class="mt-4"></canvas>
        </div>
      </div>
    </div>
    <div class="col-md-5 grid-margin stretch-card">
      <div class="card">
        <div class="card-body">
          <h4 class="card-title">Traffic Sources</h4>
          <div class="doughnutjs-wrapper d-flex justify-content-center">
            <canvas id="traffic-chart"></canvas>
          </div>
          <div id="traffic-chart-legend"
               class="rounded-legend legend-vertical legend-bottom-left pt-4">
          </div>
        </div>
      </div>
    </div>
  </div>
  

<style>
  .page-header{
    margin-top:60px;
  }


.bg-gradient-primary {
    background: linear-gradient(to right, #6ea8ff, #0041C2) !important;
}

  </style>

@endsection	