@extends('layouts.app')
@section('content')
<div class="page-header">
  <h3 class="page-title">Chat with {{ $userEmail }}</h3>
  @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
  @endif
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('admin.tickets') }}">Tickets</a></li>
      <li class="breadcrumb-item active">Chat</li>
    </ol>
  </nav>
</div>

<div class="card">
  <div class="card-body" style="max-height:60vh; overflow-y:auto;">
    @foreach($messages as $msg)
      <div class="d-flex mb-3 {{ $msg['sender']==='admin' ? 'justify-content-end' : 'justify-content-start' }}">
        <div class="p-2 {{ $msg['sender']==='admin' ? 'bg-primary text-white' : 'bg-light' }} rounded" style="max-width:75%;">
          <p class="mb-1">{{ $msg['text'] }}</p>
          <small class="text-muted">{{ $msg['timestamp']?->format('h:i A') }}</small>
        </div>
      </div>
    @endforeach
  </div>
  <div class="card-footer">
    <form method="POST" action="{{ route('admin.tickets.send',['userEmail'=>$userEmail]) }}">
      @csrf
      <div class="input-group">
        <input type="text"
               name="text"
               class="form-control"
               placeholder="Type your reply…"
               required>
        <button class="btn btn-primary" type="submit">Send</button>
      </div>
    </form>
  </div>
</div>
@endsection
