@extends('layouts.app')

@section('content')
<div class="page-header">
  <h1 class="page-title heading-color">AWA App Documentation</h1>
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
      <li class="breadcrumb-item active" aria-current="page">Documentation</li>
    </ol>
  </nav>
</div>

<div class="card">
  <div class="card-body">
    <h1 class="heading-color11">Overview</h1>
    <p>
    AWA is a voice-to-text application designed specifically for the deaf and hard-of-hearing community. It provides real-time captioning of conversations, speaker identification, notifications, and accessibility tools to ensure inclusivity and active communication.

    </p>

    <h1 class="heading-color11">Features</h1><br>
    <ul>
      <li><h4 class="heading-color123">Real-Time Speech to Text</h4></li>
        <ul>
          <li>Converts spoken words into readable text instantly</li>
          <li>High accuracy, low latency</li>
          <li>Multiple language support</li>
        </ul>
      </li>
      <li><h4 class="heading-color123">Speaker Identification</h4>
        <ul>
          <li>Distinguishes between different speakers in a group conversation</li>
          <li>Assigns labels to each speaker for clarity</li>
        </ul>
      </li>
      <li><h4 class="heading-color123">Onboarding Flow</h4>
        <ul>
          <li>Explains the purpose and benefits of the app to new users</li>
          <li>Educates users about how the app aids deaf individuals</li>
        </ul>
      </li>
      <li><h4 class="heading-color123">Notification Center</h4>
        <ul>
          <li>Displays important app notifications and updates</li>
          <li>Includes swipe-to-delete and read/unread marking</li>
        </ul>
      </li>
      <li><h4 class="heading-color123">Premium Upgrade (Go Premium)</h4>
        <ul>
          <li>Unlock advanced features like offline captioning or saved transcripts</li>
          <li>Animated glowing FAB for visibility</li>
        </ul>
      </li>
      <li><h4 class="heading-color123">Support System</h4>
        <ul>
          <li>Contact support via dedicated glowing button</li>
          <li>Custom dialogs for account blocks</li>
          <li>Access help in both light and dark mode</li>
        </ul>
      </li>
      <li><h4 class="heading-color123">Dark Mode Support</h4>
        <ul>
          <li>Dynamic theming throughout the app</li>
          <li>Improves readability and comfort for all users</li>
        </ul>
      </li>
    </ul>

    <h1 class="heading-color11">Target Audience</h1>
    <ul>
      <li>Deaf or hard-of-hearing individuals</li>
      <li>Family and educators of hearing-impaired people</li>
      <li>Interpreters and support workers</li>
    </ul>

    <h1 class="heading-color11">Technical Stack</h1>
    <ul>
      <li><strong>Frontend:</strong> Flutter (Dart)</li>
      <li><strong>State Management:</strong> Bloc</li>
      <li><strong>Backend:</strong> REST API (Python + Firebase)</li>
      <li><strong>Notifications:</strong> Firebase Cloud Messaging</li>
      <li><strong>Auth:</strong> Phone + Google/Apple</li>
      <li><strong>Third-Party Integrations:</strong> Razorpay for payment gateway, ShowcaseView, Glassmorphism package
      </li>
      
    </ul>

    <h1 class="heading-color11">Screens</h1><br>
<ul>
  <h4 class="heading-color123">LoginScreen (login_screen.dart)</h4>
  <li>Phone number entry with OTP verification.</li> 
  <li>Google/Facebook/Apple sign-in integrations.</li>
  <li> Uses firebase_auth and go_router for auth flow.</li>
  <br>
  <h4 class="heading-color123">HomeScreen (home_screen.dart)</h4>
    <li>Displays real-time transcriptions. </li>
    <li>Includes Identify Speaker button, Notification FAB, Premium FAB, and Support FAB. </li>
    <li>Manages glow animations and state transitions using AnimationController.</li>
    <br>
  <h4 class="heading-color123">OnboardingScreen (onboarding_screen.dart)</h4>
    <li>PageView with 3 onboarding slides. </li>
    <li>Shows benefits of the app to new users.</li>
    <li> Uses PageController and fade/slide animations.
  </li>
  <br>
  <h4 class="heading-color123">NotificationScreen (notification_screen.dart)</h4>
    <li>Displays fetched notifications via REST API.</li>
    <li> Allows delete and mark-as-read.
    <li> Uses Slidable package with Glassmorphism styling and error handling.
  </li>
  <br>
  <h4 class="heading-color123">SupportScreen / ContactSupportScreen (contact_support_screen.dart)</h4>
    <li>Contact support via animated glowing FAB.</li>
    <li> Navigates using GoRouter.</li>
    <li> Dynamic dark mode support and blurred UI overlay.
  </li>
  <br>
  <h4 class="heading-color123">SubscriptionDialog (subscription_dialog.dart)</h4>
    <li>Prompt shown to non-premium users. </li>
    <li>FAB animates and triggers this dialog. </li>
    <li>Uses showDialog with styled AlertDialog and Razorpay integration.
  </li>
  <br>
  <h4 class="heading-color123">SpeakerIdentificationScreen (identify_speaker_screen.dart)</h4>
    <li>Displays individual speaker labels and voice activity. </li>
        <li>Uses real-time microphone access and maps transcribed content to speakers.
  </li>
  <br>
  <h4 class="heading-color123">CompleteProfileScreen (complete_profile_screen.dart)</h4>
    <li>After phone login, user sets up name and avatar. </li>
    <li>Stores user data to backend or shared_preferences.
  </li>
  <br>
  <h4 class="heading-color123">LanguageSelectionScreen (language_selection_screen.dart)</h4>
    <li>Allows user to pick a language for UI or speech-to-text engine.</li>
    <li> List populated with dropdowns and saved locally.
  </li>
  <br>
  <h4 class="heading-color123">SettingsScreen (settings_screen.dart)</h4>
    <li>Toggles for dark mode, app language, feedback. </li>
    <li>Includes logout and premium upgrade options.
  </li>
</ul>

<h1 class="heading-color11">Privacy & Security</h1>
<ul>
  <li>Data stored securely</li>
  <li>Users can delete notifications</li>
  <li>Complies with platform policies (GDPR-ready)</li>
  <li>Privacy Policy and Terms integrated for Razorpay and Play Store compliance</li>
</ul>

<h1 class="heading-color11">Support and Feedback</h1>
<ul>
  <li>In-app support contact</li>
  <li>Chat support</li>
  <li>Feedback collection after sessions</li>
</ul>

<h1 class="heading-color11">Deployment</h1>
<ul>
  <li>Android & iOS support</li>
  <li>Hosted backend with dio API</li>
  <li>Firebase for messaging and analytics</li>
</ul>

<h1 class="heading-color11">Packages</h1>
<ul>
  <li>go_router</li>
  <li>flutter_bloc</li>
  <li>firebase_auth</li>
  <li>firebase_messaging</li>
  <li>shared_preferences</li>
  <li>http</li>
  <li>razorpay_flutter</li>
  <li>showcaseview</li>
  <li>glassmorphism</li>
  <li>flutter_slidable</li>
</ul>
  </div>
</div>

<style>

    .heading-color{
        color:#0041C2;
    }

    .heading-color11{
        color:#6699cc;
    }

    .heading-color123{
        color:#8cb3d9;
    }

    </style>
@endsection
