@extends('layouts.app')
@section('content')
<div class="page-header">
  <h3 class="page-title">All User Messages</h3>
</div>

<div class="card">
  <div class="card-body">
    <h4 class="card-title">Messages</h4>
    <div class="table-responsive">
      <table class="table">
        <thead>
          <tr>
            <th>User Email</th>
            <th>Message</th>
            <th>Time</th>
          </tr>
        </thead>
        <tbody>
          @forelse($messages as $m)
            <tr>
              <td>{{ $m['user_email'] }}</td>
              <td>{{ $m['text'] }}</td>
              <td>{{ $m['timestamp']?->format('M d, Y h:i A') }}</td>
            </tr>
          @empty
            <tr>
              <td colspan="3" class="text-center">No messages found.</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    <div class="mt-3">
      {{ $messages->links() }}
    </div>
  </div>
</div>
@endsection
