@extends('layouts.app')
@section('content')
  <div class="page-header">
    <h3 class="page-title">All Notifications</h3>
  </div>

  <div class="card">
    <div class="card-body">
      <ul class="list-group">
        @forelse($notifications as $n)
          <li class="list-group-item d-flex justify-content-between align-items-start">
            <div>
              <strong>{{ $n['user_email'] }}</strong><br>
              {{ $n['message'] }}
            </div>
            <small class="text-muted">
              {{ $n['timestamp']?->format('M d, Y h:i A') }}
            </small>
          </li>
        @empty
          <li class="list-group-item text-center">No notifications yet.</li>
        @endforelse
      </ul>
    </div>
  </div>
  <div class="mt-3">
      {{ $notifications->links() }}
    </div>
@endsection
