@extends('layouts.app')

@section('content')
<div class="page-header">
  <h3 class="page-title">Speakers</h3>
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="#">Speakers</a></li>
      <li class="breadcrumb-item active" aria-current="page">List</li>
    </ol>
  </nav>
</div>
<div class="row">
  <div class="col-lg-12 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">Speakers Table</h4>
        <div class="table-responsive">
          <table class="table table-striped">
            <thead>
              <tr>
                <th>User</th>
                <th>Speaker</th>
                <th>Speaker Added By</th>
                <!-- <th>Chart</th> -->
              </tr>
            </thead>
            <tbody>
              @forelse ($speakers as $speaker)
                <tr>
                  <!-- static placeholder pic -->
                  <td class="py-1">
                    <img src="{{ asset('assets/images/faces-clipart/pic-1.png') }}"
                         alt="speaker" />
                  </td>
                  <td>{{ $speaker['name'] }}</td>
                  <td>{{ $speaker['email'] }}</td>
                  <!-- <td><i class="fa-brands fa-rocketchat"></i></td> -->
                </tr>
              @empty
                <tr>
                  <td colspan="4" class="text-center">No speakers found.</td>
                </tr>
              @endforelse
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="mt-3">
  {{ $speakers->links() }}
</div>
@endsection
