@extends('layouts.app')

@section('content')
<div class="page-header">
  <h3 class="page-title">Subscribed Users</h3>
  @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
  @endif
  @if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
  @endif
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
      <li class="breadcrumb-item active" aria-current="page">Subscribed Users</li>
    </ol>
  </nav>
</div>

<div class="card">
  <div class="card-body">
    <h4 class="card-title">Users with Active Subscriptions</h4>
    <div class="table-responsive">
      <table class="table table-striped">
        <thead>
          <tr>
            <th>Email</th>
            <th>Plan</th>
            <th>Price (INR)</th>
            <th>Duration (days)</th>
            <th>Last Updated</th>
          </tr>
        </thead>
        <tbody>
          @forelse($users as $u)
            <tr>
              <td>{{ $u['email'] }}</td>
              <td>{{ $u['plan_name'] }}</td>
              <td>{{ number_format((float)$u['price'], 2) }}</td>
              <td>{{ $u['duration_days'] }}</td>
              <td>
                {{ $u['last_updated'] instanceof \Carbon\Carbon 
                    ? $u['last_updated']->format('M d, Y h:i A') 
                    : (string) $u['last_updated'] }}
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="5" class="text-center">No subscribed users found.</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>
</div>
@endsection
