
@extends('layouts.app')

@section('content')
<div class="page-header">
  <h3 class="page-title">Manage Subscription Plan</h3>
  <!-- <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
      <li class="breadcrumb-item active" aria-current="page">Subscription</li>
    </ol>
  </nav> -->
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('admin.subscriptions') }}">Subscriptions</a></li>
      <li class="breadcrumb-item active">{{ $plan ? 'Edit' : 'Create' }}</li>
    </ol>
  </nav>
</div>

@if(session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif
@if($errors->has('form'))
  <div class="alert alert-danger">{{ $errors->first('form') }}</div>
@endif

<div class="row">
  <div class="col-md-12 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title mb-5">Add / Update Plan</h4>
        <!-- <form method="POST" action="{{ route('subscription.store') }}"> -->
        <form method="POST"
          action="{{ $plan 
             ? route('subscription.update', $plan['plan_name']) 
             : route('subscription.store') }}">
          @csrf

          <div class="form-group">
            <label for="plan_name">Plan Name</label>
            <input id="plan_name"
                   name="plan_name"
                   type="text"
                   class="form-control @error('plan_name') is-invalid @enderror"
                   value="{{ old('plan_name', $plan['plan_name'] ?? '') }}"
                   {{ $plan ? 'readonly disabled' : '' }}>
            @error('plan_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
          </div>

          <div class="form-group">
            <label for="duration_days">Duration (days)</label>
            <input id="duration_days"
                   name="duration_days"
                   type="number"
                   min="1"
                   class="form-control @error('duration_days') is-invalid @enderror"
                   value="{{ old('duration_days', $plan['duration_days'] ?? '') }}">
            @error('duration_days')<div class="invalid-feedback">{{ $message }}</div>@enderror
          </div>

           <div class="form-group">
            <label for="price">Price (INR)</label>
            <input id="price"
                   name="price"
                   type="number"
                   step="0.01"
                   class="form-control @error('price') is-invalid @enderror"
                   value="{{ old('price', $plan['price'] ?? '') }}">
            @error('price')<div class="invalid-feedback">{{ $message }}</div>@enderror
          </div>

        <!--  <div class="form-group">
            <label>Features</label>
            <div id="features-wrapper">
              <div class="input-group mb-2">
                <input type="text"
                       name="features[]"
                       class="form-control @error('features.0') is-invalid @enderror"
                       placeholder="Feature description"
                       value="{{ old('features.0') }}">
                <button type="button" class="btn btn-outline-secondary remove-feature">×</button>
              </div>
            </div>
            @if($errors->has('features'))
              <div class="text-danger">{{ $errors->first('features') }}</div>
            @endif
            @error('features.*')<div class="text-danger">{{ $message }}</div>@enderror

            <button type="button" id="add-feature" class="btn btn-sm btn-link">+ Add another feature</button>
          </div>

          <button type="submit" class="btn btn-gradient-primary">Submit</button>
          <a href="{{ route('admin.dashboard') }}" class="btn btn-light ms-2">Cancel</a>
        </form> -->

        <div class="form-group">
        <label>Features</label>
        <div id="features-wrapper">
          @php
            $old_feats = old('features', $plan['features'] ?? []);
          @endphp

          @foreach($old_feats as $i => $feat)
            <div class="input-group mb-2">
              <input type="text"
                     name="features[]"
                     value="{{ $feat }}"
                     class="form-control">
              <button type="button" class="btn btn-outline-secondary remove-feature">×</button>
            </div>
          @endforeach

          @if(empty($old_feats))
            <div class="input-group mb-2">
              <input type="text" name="features[]" class="form-control" placeholder="Feature">
              <button type="button" class="btn btn-outline-secondary remove-feature">×</button>
            </div>
          @endif
        </div>
        @error('features.*')
          <div class="text-danger">{{ $message }}</div>
        @enderror
        <button type="button" id="add-feature" class="btn btn-sm btn-link">+ Add Another feature</button>
      </div>

      <button type="submit" class="btn btn-gradient-primary me-2">
        {{ $plan ? 'Update' : 'Create' }}
      </button>
      <a href="{{ route('admin.subscriptions') }}" class="btn btn-light ms-2">Cancel</a>
    </form>
      </div>
    </div>
  </div>
</div>


<script>
  document.getElementById('add-feature').addEventListener('click', function(){
    const wrapper = document.getElementById('features-wrapper');
    const idx     = wrapper.querySelectorAll('input[name="features[]"]').length;
    const div     = document.createElement('div');
    div.className = 'input-group mb-2';
    div.innerHTML = `
      <input type="text"
             name="features[]"
             class="form-control"
             placeholder="Feature description"
      >
      <button type="button" class="btn btn-outline-secondary remove-feature">×</button>
    `;
    wrapper.appendChild(div);
  });

  document.getElementById('features-wrapper').addEventListener('click', function(e){
    if (e.target.matches('.remove-feature')) {
      e.target.closest('.input-group').remove();
    }
  });
</script>

@endsection
