@extends('layouts.app')

@section('content')
<div class="page-header">
  <h3 class="page-title">Subscription Plans</h3>
  @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
  @endif
  @if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
  @endif
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
      <li class="breadcrumb-item active" aria-current="page">Subscriptions</li>
    </ol>
  </nav>
</div>

<div class="row">
  <div class="col-12 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">Available Plans</h4>
        <div class="table-responsive">
          <table class="table table-striped">
            <thead>
              <tr>
                <th>Plan Name</th>
                <th>Duration (days)</th>
                <th>Price (INR)</th>
                <th>Features</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @forelse($plans as $plan)
                <tr>
                  <td>{{ $plan['plan_name'] }}</td>
                  <td>{{ $plan['duration_days'] }}</td>
                  <td>{{ number_format($plan['price'], 2) }}</td>
                  <td>
                    @if(!empty($plan['features']) && is_array($plan['features']))
                      {{ implode(', ', $plan['features']) }}
                    @else
                      —
                    @endif
                  </td>
                  <td>
                  <a
                    href="{{ route('subscription.edit', ['plan_name' => $plan['plan_name']]) }}"
                     class="btn btn-sm btn-secondary"
                        >
                          Edit
                        </a>

                <form action="{{ route('subscription.destroy', $plan['plan_name']) }}"
                      method="POST"
                      style="display:inline"
                      onsubmit="return confirm('Delete this plan?');">
                  @csrf
                  @method('DELETE')
                  <button class="btn btn-sm btn-danger">Delete</button>
                </form>
              </td>
                </tr>
              @empty
                <tr>
                  <td colspan="4" class="text-center">No plans found.</td>
                </tr>
              @endforelse
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
