
@extends('layouts.app')

@section('content')
<div class="page-header">
  <h3 class="page-title">Contact Support</h3>
  @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
  @endif
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="#">Tickets</a></li>
      <li class="breadcrumb-item active">List</li>
    </ol>
  </nav>
</div>

<div class="card">
  <div class="card-body">
    <h2 class="card-title mb-5">Recent Tickets</h2>
    <div class="table-responsive">
      <table class="table">
        <thead>
          <tr>
            <th>User Email</th>
            <th>Assignee</th>
            <th>Subject</th>
            <th>Status</th>
            <th>Last Update</th>
            <th>Tracking ID</th>
          </tr>
        </thead>
        <tbody>
          @forelse($tickets as $t)
          <tr>
            <td>{{ $t['user_email'] }}</td>
            <td>
              <img src="{{ asset('assets/images/faces/face1.jpg') }}"
                   class="me-2 rounded-circle" width="32" height="32" alt="">
              {{ $t['sender'] }}
            </td>
            <td>{{ $t['text'] }}</td>
            <td>
              @if($t['status']==='DONE')
                <label class="badge badge-gradient-success">DONE</label>
              @else
                <label class="badge badge-gradient-warning">PROGRESS</label>
              @endif
            </td>
            <td>{{ $t['timestamp']?->format('M d, Y h:i A') ?? '—' }}</td>
            <td>{{ $t['id'] }}</td>
          </tr>
          @empty
          <tr>
            <td colspan="6" class="text-center">No tickets found.</td>
          </tr>
          @endforelse
        </tbody>
      </table>
    </div>
    <div class="mt-3">
      {{ $tickets->links() }}
    </div>
  </div>
</div>
@endsection
