@extends('layouts.app')

@section('content')
<div class="page-header">
  <h3 class="page-title">Transaction History</h3>

  @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
  @endif
  @if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
  @endif

  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
      <li class="breadcrumb-item active" aria-current="page">Transactions</li>
    </ol>
  </nav>
</div>

<div class="card">
  <div class="card-body">
    <h4 class="card-title mb-5">Razorpay Transactions</h4>
    <div class="table-responsive">
      <table class="table table-striped">
        <thead>
          <tr>
            <th>Email</th>
            <th>Amount</th>
            <th>Order ID</th>
            <th>Payment ID</th>
            <th>Signature</th>
            <th>Last Updated</th>
          </tr>
        </thead>
        <tbody>
          @forelse($transactions as $t)
            <tr>
              <td>{{ $t['email'] }}</td>
              <td>{{ number_format((float)$t['amount'], 2) }}</td>
              <td>{{ $t['razorpay_order_id'] }}</td>
              <td>{{ $t['razorpay_payment_id'] }}</td>
              <td>{{ $t['generated_signature'] }}</td>
              <td>
                {{ $t['last_updated'] instanceof \Carbon\Carbon
                    ? $t['last_updated']->format('M d, Y h:i A')
                    : '—' }}
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="6" class="text-center">No transactions found.</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>
</div>
@endsection
