{{-- resources/views/awa/pages/trial-settings.blade.php --}}
@extends('layouts.app')
@section('content')
  <div class="page-header">
    <h3 class="page-title">App Trial Settings</h3>
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
        <li class="breadcrumb-item active">Trial</li>
      </ol>
    </nav>
  </div>

  @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
  @endif
  @if($errors->has('form'))
    <div class="alert alert-danger">{{ $errors->first('form') }}</div>
  @endif

  <div class="row">
    <div class="col-12 grid-margin stretch-card">
      <div class="card">
        <div class="card-body">
          <h4 class="card-title">Enable / Disable Trial</h4>

          <form method="POST" action="{{ route('admin.trial.set') }}">
            @csrf

            <div class="form-group row align-items-center">
              <label class="col-sm-3 col-form-label">Trial Enabled</label>
              <div class="col-sm-9">
                {{-- always send false if unchecked --}}
                <input type="hidden" name="trial_enabled" value="false">

                <div class="form-check form-switch">
                  <input class="form-check-input"
                         type="checkbox"
                         id="trial_enabled"
                         name="trial_enabled"
                         value="true"
                         {{ old('trial_enabled', $trial_enabled ? 'true' : 'false') === 'true' ? 'checked' : '' }}>
                  <label class="form-check-label" for="trial_enabled">
                    {{ old('trial_enabled', $trial_enabled ? 'true' : 'false') === 'true' ? 'On' : 'Off' }}
                  </label>
                </div>
                @error('trial_enabled')
                  <div class="text-danger">{{ $message }}</div>
                @enderror
              </div>
            </div>

            <div class="form-group">
                <label for="trail_days">Duration (days)</label>
                <input id="trail_days"
                    name="trail_days"
                    type="number"
                    class="form-control @error('trail_days') is-invalid @enderror"
                    value="{{ old('trail_days', $trail_days) }}">
                @error('trail_days')
                <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <button type="submit" class="btn btn-gradient-primary me-2">Submit</button>
            <button type="button"
                    class="btn btn-light"
                    onclick="window.history.back()">Cancel</button>
          </form>
        </div>
      </div>
    </div>
  </div>


<script>
  const chk = document.getElementById('trial_enabled');
  const lbl = document.querySelector("label[for='trial_enabled']");

  function updateLabel() {
    if (chk.checked) {
      lbl.textContent = 'On';
    } else {
      lbl.textContent = 'Off';
    }
  }

  
  updateLabel();

  
  chk.addEventListener('change', () => {
    updateLabel();
  });
</script>



@endsection
