@extends('layouts.app')

@section('content')
<div class="page-header">
  <h3 class="page-title">Update Admin Profile</h3>
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="#">Admin</a></li>
      <li class="breadcrumb-item active" aria-current="page">Profile</li>
    </ol>
  </nav>
</div>

@if(session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif
@if($errors->has('form'))
  <div class="alert alert-danger">{{ $errors->first('form') }}</div>
@endif

<div class="row">
  <div class="col-12 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">Update Admin Profile</h4>
        <p class="card-description">Admin can change their profile details here</p>

        <form method="POST"
              action="{{ route('admin.profile.update') }}"
              class="forms-sample"
              enctype="multipart/form-data">
          @csrf

          <div class="form-group">
            <label for="name">Name</label>
            <input id="name"
                   name="name"
                   type="text"
                   class="form-control @error('name') is-invalid @enderror"
                   value="{{ old('name', $name) }}">
            @error('name')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

          <div class="form-group">
            <label for="email">Email address</label>
            <input id="email"
                  
                   type="email"
                   class="form-control @error('email') is-invalid @enderror"
                   value="{{ old('email', $email) }}"
                   readonly
                   disabled
                   >
            @error('email')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

          <input type="hidden" name="email" value="{{ $email }}">

          <div class="form-group">
            <label for="password">New Password</label>
            <input id="password"
                   name="password"
                   type="password"
                   class="form-control @error('password') is-invalid @enderror"
                   placeholder="Leave blank to keep current">
            @error('password')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

         <div class="mb-5">
            <label for="profile_pic" class="form-label">Upload New Avatar</label>
            <input 
                class="form-control @error('profile_pic') is-invalid @enderror" 
                type="file" 
                id="profile_pic" 
                name="profile_pic"
            >
            @error('profile_pic')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
            </div>


          <button type="submit" class="btn btn-gradient-primary me-2">Submit</button>
          <a href="{{ route('admin.dashboard') }}" class="btn btn-light">Cancel</a>
        </form>

      </div>
    </div>
  </div>
</div>
@endsection
