@extends('layouts.app')

@section('content')
  <div class="page-header">
    <h3 class="page-title">Blocked Users</h3>
    @if(session('success'))
      <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
      <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="#">Users</a></li>
        <li class="breadcrumb-item active">Blocked</li>
      </ol>
    </nav>
  </div>

  <div class="row">
    <div class="col-lg-12 grid-margin stretch-card">
      <div class="card">
        <div class="card-body">
          <h4 class="card-title">Blocked Users Table</h4>
          <div class="table-responsive">
            <table class="table table-striped">
              <thead>
                <tr>
                  <th>User</th>
                  <th>Name</th>
                  <th>Email</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>
                @forelse($users as $user)
                  <tr>
                    <td class="py-1">
                      <img src="{{ asset('assets/images/faces-clipart/pic-1.png') }}"
                           alt="user" />
                    </td>
                    <td>{{ $user['name'] }}</td>
                    <td>{{ $user['email'] }}</td>
                    <td>
                      <form
                        action="{{ route('admin.users.unblock') }}"
                        method="POST"
                        onsubmit="return confirm('Are you sure you want to unblock {{ $user['email'] }}?');"
                      >
                        @csrf
                        <input type="hidden" name="email" value="{{ $user['email'] }}">
                        <button type="submit"
                                class="btn btn-sm btn-danger">
                          Unblock
                        </button>
                      </form>
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="4" class="text-center">No blocked users.</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="mt-3">
  {{ $users->links() }}
</div>
@endsection
