@extends('layouts.app')

@section('content')
@php
    if (session()->has('admin_token')) {
        $role = 'admin';
    } elseif (Auth::check()) {
        $role = Auth::user()->role; // 'user'
    } else {
        $role = null;
    }
@endphp
<div class="page-header">
  <h3 class="page-title">User List</h3>
  @if(session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif
@if(session('error'))
  <div class="alert alert-danger">{{ session('error') }}</div>
@endif
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="#">Users</a></li>
      <li class="breadcrumb-item active" aria-current="page">List</li>
    </ol>
  </nav>
 
</div>
<div class="row">
  <div class="col-lg-12 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">Users Table</h4>
        <div class="table-responsive">
          <table class="table table-striped">
            <thead>
              <tr>
                <th> User </th>
                <th> Name </th>
                <th> Email </th>
                <!-- <th> Add User </th>
                <th> Chat </th> -->
                @if($role === 'admin')
                <th> Action </th>
                @endif
              </tr>
            </thead>
            <tbody>
            @forelse($users as $user)
              <tr>
                <td class="py-1">
                  <!-- static placeholder pic -->
                  <img src="{{ asset('assets/images/faces-clipart/pic-1.png') }}" alt="user" />
                </td>
                <td>{{ $user['name'] }}</td>
                <td>{{ $user['email'] }}</td>
                <!-- <td>
                  <i class="fa-solid fa-user-plus"></i>
                </td>
                <td>
                  <i class="fa-brands fa-rocketchat"></i>
                </td> -->
                @if($role === 'admin')
                <td>
          <form
            action="{{ route('admin.users.destroy') }}"
            method="POST"
            onsubmit="return confirm('Are you sure you want to block this user?');"
          >
            @csrf
            <input type="hidden" name="email" value="{{ $user['email'] }}">
            <button type="submit" class="btn btn-sm btn-danger">
              Block
            </button>
          </form>
        </td>
        @endif
              </tr>
            @empty
              <tr>
                <td colspan="5" class="text-center">No users found.</td>
              </tr>
            @endforelse
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="mt-3">
  {{ $users->links() }}
</div>
@endsection
