@extends('layouts.app')

@section('content')
<div class="page-header">
  <h3 class="page-title">
    {{ $user->exists ? 'Edit Dashboard User' : 'New Dashboard User' }}
  </h3>
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item">
        <a href="{{ route('users.index') }}">Dashboard Users</a>
      </li>
      <li class="breadcrumb-item active" aria-current="page">
        {{ $user->exists ? 'Edit' : 'Create' }}
      </li>
    </ol>
  </nav>
</div>

@if(session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif
@if($errors->has('form'))
  <div class="alert alert-danger">{{ $errors->first('form') }}</div>
@endif

<div class="row">
  <div class="col-12 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title mb-4">{{ $user->exists ? 'Update User' : 'Add User' }}</h4>
        <form
          method="POST"
          action="{{ $user->exists
                     ? route('users.update', $user)
                     : route('users.store') }}"
          enctype="multipart/form-data"
          class="forms-sample"
        >
          @csrf
          @if($user->exists)
            @method('PUT')
          @endif

          <div class="form-group">
            <label for="name">Name</label>
            <input id="name"
                   name="name"
                   type="text"
                   class="form-control @error('name') is-invalid @enderror"
                   value="{{ old('name', $user->name) }}">
            @error('name')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

          <div class="form-group">
            <label for="email">Email address</label>
            <input id="email"
                  name="email"   
                  type="email"
                  class="form-control @error('email') is-invalid @enderror"
                  value="{{ old('email', $user->email) }}"
                  {{ $user->exists ? 'readonly disabled' : '' }}>
            @error('email')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

          {{-- Hidden email only needed when editing (because disabled inputs are not submitted) --}}
          @if($user->exists)
            <input type="hidden" name="email" value="{{ $user->email }}">
          @endif


          <div class="form-group">
            <label for="password">
              {{ $user->exists ? 'New Password (leave blank to keep)' : 'Password' }}
            </label>
            <input id="password"
                   name="password"
                   type="password"
                   class="form-control @error('password') is-invalid @enderror"
                   placeholder="{{ $user->exists ? 'Leave blank to keep current' : '' }}">
            @error('password')
              <div class="invalid-feedback">{{ $message }}</div>
            @enderror
          </div>

          <div class="form-group">
            <label for="password_confirmation">
              {{ $user->exists ? 'Confirm New Password' : 'Confirm Password' }}
            </label>
            <input id="password_confirmation"
                   name="password_confirmation"
                   type="password"
                   class="form-control">
          </div>

         <div class="form-group">
        <label for="avatar_file">Avatar (optional)</label>
        @if($user->exists && $user->avatar_url)
          <div class="mb-2">
            <img src="{{ $user->avatar_url }}"
                width="48" height="48"
                class="rounded-circle"
                alt="current avatar">
          </div>
        @endif
        <input id="avatar_file"
              name="avatar_file"      {{-- changed name --}}
              type="file"
              class="form-control @error('avatar_file') is-invalid @enderror">
        @error('avatar_file')
          <div class="invalid-feedback">{{ $message }}</div>
        @enderror
      </div>


          <button type="submit"
                  class="btn btn-gradient-primary me-2">
            {{ $user->exists ? 'Update' : 'Create' }}
          </button>
          <a href="{{ route('users.index') }}" class="btn btn-light">Cancel</a>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection
