@extends('layouts.app')
@section('content')

<div class="page-header">
  <h3 class="page-title">Dashboard Users</h3>
  <a href="{{ route('users.create') }}" class="btn btn-sm btn-primary float-end">New User</a>
</div>

@if(session('success'))
  <div class="alert alert-success">{{ session('success') }}</div>
@endif

<div class="card">
  <div class="card-body">
    <div class="table-responsive">
    <table class="table table-striped">
  <thead>
    <tr>
      <th>User</th>
      <th>Name</th>
      <th>Email</th>
      <th>Action</th>
    </tr>
  </thead>
  <tbody>
    @forelse($users as $u)
    <tr>
      <td class="py-1">
        <img src="{{ $u->avatar_url ?? asset('assets/images/faces-clipart/pic-1.png') }}"
             class="rounded-circle"
             width="32"
             height="32"
             alt="avatar">
      </td>
      <td>{{ $u->name }}</td>
      <td>{{ $u->email }}</td>
      <td>
        <a href="{{ route('users.edit',['dashboard_user' => $u->id]) }}"
           class="btn btn-sm btn-secondary">Edit</a>
        <form action="{{ route('users.destroy', $u->id) }}"
              method="POST"
              style="display:inline"
              onsubmit="return confirm('Delete this user?');">
          @csrf @method('DELETE')
          <button class="btn btn-sm btn-danger">Delete</button>
        </form>
      </td>
    </tr>
    @empty
    <tr><td colspan="4" class="text-center">No users</td></tr>
    @endforelse
  </tbody>
</table>
      {{ $users->links() }}
    </div>
  </div>
</div>
@endsection
