{{-- resources/views/layouts/header.blade.php --}}
<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Awa Admin</title>

  <!-- plugins:css -->
  <link rel="stylesheet" href="{{ asset('assets/vendors/mdi/css/materialdesignicons.min.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/vendors/ti-icons/css/themify-icons.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/vendors/css/vendor.bundle.base.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/vendors/font-awesome/css/font-awesome.min.css') }}">
  <!-- endinject -->

  <!-- Plugin css for this page -->
  <link rel="stylesheet" href="{{ asset('assets/vendors/font-awesome/css/font-awesome.min.css') }}" />

  <script src="https://kit.fontawesome.com/977f5ac5ed.js" crossorigin="anonymous"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  
  <link rel="stylesheet" href="{{ asset('assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css') }}">
  <!-- End plugin css for this page -->

  <!-- inject:css -->
  <!-- endinject -->

  <!-- Layout styles -->
  <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
  <!-- End layout styles -->

  <link rel="shortcut icon" href="{{ asset('assets/images/awa_logo.png') }}" /> 
  <meta name="admin-email" content="{{ session('admin_email') }}">
  @php use Carbon\Carbon; @endphp
</head>
<body>
  <div class="container-scroller">
   

    <!-- partial:partials/_navbar.html -->
    <nav class="navbar default-layout-navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-start">
        <a class="navbar-brand brand-logo" href="#">
          <img src="{{ asset('assets/images/awa11.png') }}" alt="logo" />
        </a>
        <a class="navbar-brand brand-logo-mini" href="index.html">
          <img src="{{ asset('assets/images/logo-mini.svg') }}" alt="logo" />
        </a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-stretch">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu"></span>
        </button>
        <div class="search-field d-none d-md-block">
          <form class="d-flex align-items-center h-100" action="#">
            <div class="input-group">
              <div class="input-group-prepend bg-transparent">
                <i class="input-group-text border-0 mdi mdi-magnify"></i>
              </div>
              <input type="text"
                     class="form-control bg-transparent border-0"
                     placeholder="Search projects">
            </div>
          </form>
        </div>
        <!-- <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown">
            <a class="nav-link dropdown-toggle"
               id="profileDropdown"
               href="#"
               data-bs-toggle="dropdown"
               aria-expanded="false">
              <div class="nav-profile-img">
                <img src="{{ asset('assets/images/faces/face1.jpg') }}" alt="profile image" id="admin-avatar-img">
               <span class="availability-status online"></span>
              </div>
              <div class="nav-profile-text">
                <p class="mb-1 text-black" id="admin-name"> {{ session('admin_name', 'Admin') }}</p>
              </div>
            </a> -->

            @if (Auth::check() && Auth::user()->role === 'user')
            <ul class="navbar-nav navbar-nav-right">
            <li class="nav-item nav-profile dropdown">
              <a class="nav-link dropdown-toggle"
                id="userProfileDropdown"
                href="#"
                data-bs-toggle="dropdown"
                aria-expanded="false">
                <div class="nav-profile-img">
                  <img
                    src="{{ Auth::user()->avatar_url ?? asset('assets/images/faces/face1.jpg') }}"
                    alt="profile image"
                    id="user-avatar-img">
                  <span class="availability-status online"></span>
                </div>
                <div class="nav-profile-text">
                  <p class="mb-1 text-black" id="user-name">
                    {{ Auth::user()->name }}
                  </p>
                </div>
              </a>

            <div class="dropdown-menu navbar-dropdown" aria-labelledby="profileDropdown">
              <!-- <a class="dropdown-item" href="#">
                <i class="mdi mdi-cached me-2 text-success"></i> Activity Log
              </a> -->
              <div class="dropdown-divider"></div>
              <a class="dropdown-item" href="#"
              onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
             <i class="mdi mdi-logout me-2 text-primary"></i> Signout
              </a>
              <form id="logout-form"
                action="{{ route('admin.logout') }}"
                method="POST"
                class="d-none">
            @csrf
          </form>
            </div>
          </li>
          @elseif (session()->has('admin_token'))
   <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown">
            <a class="nav-link dropdown-toggle"
               id="profileDropdown"
               href="#"
               data-bs-toggle="dropdown"
               aria-expanded="false">
              <div class="nav-profile-img">
                <img src="{{ asset('assets/images/faces/face1.jpg') }}" alt="profile image" id="admin-avatar-img">
               <span class="availability-status online"></span>
              </div>
              <div class="nav-profile-text">
                <p class="mb-1 text-black" id="admin-name"> {{ session('admin_name', 'Admin') }}</p>
              </div>
            </a>
      <div class="dropdown-menu navbar-dropdown" aria-labelledby="profileDropdown">
              <!-- <a class="dropdown-item" href="#">
                <i class="mdi mdi-cached me-2 text-success"></i> Activity Log
              </a> -->
              <div class="dropdown-divider"></div>
              <a class="dropdown-item" href="#"
              onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
             <i class="mdi mdi-logout me-2 text-primary"></i> Signout
              </a>
              <form id="logout-form"
                action="{{ route('admin.logout') }}"
                method="POST"
                class="d-none">
            @csrf
          </form>
            </div>
          </li>
          @endif
          <li class="nav-item d-none d-lg-block full-screen-link">
            <a class="nav-link">
              <i class="mdi mdi-fullscreen" id="fullscreen-button"></i>
            </a>
          </li>
         


          <li class="nav-item dropdown">
  <a class="nav-link count-indicator dropdown-toggle"
     id="messageDropdown"
     href="#"
     data-bs-toggle="dropdown"
     aria-expanded="false">
    <i class="mdi mdi-email-outline"></i>
    @if(count($recentMessages))
      <span class="count-symbol bg-warning"></span>
    @endif
  </a>
  <div class="dropdown-menu dropdown-menu-end navbar-dropdown preview-list"
       aria-labelledby="messageDropdown">
    <h6 class="p-3 mb-0">Messages</h6>
    <div class="dropdown-divider"></div>

    @forelse($recentMessages as $msg)
      <a class="dropdown-item preview-item" href="{{ route('admin.tickets.chat',['userEmail'=>$msg['user_email']]) }}">
        <div class="preview-thumbnail">
          <img src="{{ asset('assets/images/faces/face4.jpg') }}"
               alt="image"
               class="profile-pic">
        </div>
        <div class="preview-item-content d-flex align-items-start flex-column justify-content-center">
          <h6 class="preview-subject ellipsis mb-1 font-weight-normal">
            {{ $msg['user_email'] }}
          </h6>
          <p class="text-gray mb-0">
            {{ Str::limit($msg['text'], 30) }}
          </p>
          <small class="text-muted">
          {{ Carbon::instance($msg['time'])->diffForHumans() }}
          </small>
        </div>
      </a>
      <div class="dropdown-divider"></div>
    @empty
      <p class="text-center text-muted my-2">No recent messages</p>
      <div class="dropdown-divider"></div>
    @endforelse

    <h6 class="p-3 mb-0 text-center">
      <a href="{{ route('admin.messages') }}">See all messages</a>
    </h6>
  </div>
</li>

          
    <li class="nav-item dropdown">
  <a class="nav-link count-indicator dropdown-toggle"
     id="notificationDropdown"
     href="#"
     data-bs-toggle="dropdown">
    <i class="mdi mdi-bell-outline"></i>
    @if(count($adminNotifications))
      <span class="count-symbol bg-danger"></span>
    @endif
  </a>
  <div class="dropdown-menu dropdown-menu-end navbar-dropdown preview-list"
       aria-labelledby="notificationDropdown">
    <h6 class="p-3 mb-0">Notifications</h6>
    <div class="dropdown-divider"></div>

    @forelse($adminNotifications as $note)
      <a class="dropdown-item preview-item">
        <div class="preview-thumbnail">
          <div class="preview-icon bg-info">
            <i class="mdi mdi-bell-ring"></i>
          </div>
        </div>
        <div class="preview-item-content d-flex align-items-start flex-column justify-content-center">
          <h6 class="preview-subject font-weight-normal mb-1">
            User Notified: {{ $note['user_email'] }}
          </h6>
          <p class="text-gray ellipsis mb-0">
            {{ Str::limit($note['message'], 50) }}
          </p>
        </div>
      </a>
      <div class="dropdown-divider"></div>
    @empty
      <p class="text-center text-muted my-2">No notifications</p>
      <div class="dropdown-divider"></div>
    @endforelse

    <h6 class="p-3 mb-0 text-center">
      <a href="{{ route('admin.notifications.all') }}">See all notifications</a>
    </h6>
  </div>
</li>
          <li class="nav-item nav-logout d-none d-lg-block">
            <a class="nav-link" href="#">
              <i class="mdi mdi-power"></i>
            </a>
          </li>
          <li class="nav-item nav-settings d-none d-lg-block">
            <a class="nav-link" href="#">
              <i class="mdi mdi-format-line-spacing"></i>
            </a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center"
                type="button"
                data-toggle="offcanvas">
          <span class="mdi mdi-menu"></span>
        </button>
      </div>
    </nav>
    <!-- end of header partial -->


    <style>

.navbar .navbar-brand-wrapper .navbar-brand img {
  height: 60px;
    width: 200px;
}

.page-header{
  margin-top:60px;
}

.btn-gradient-primary {
  background: linear-gradient(to right, #6ea8ff, #0041C2) !important;
}

.content-wrapper {
    padding-bottom: 150px;
}


      </style> 


<script>
  $(function() {
    var email = $('meta[name="admin-email"]').attr('content');
    if (!email) return;

    var base = '{{ config("services.admin_api.base_url") }}';
    var url  = base + '/get_admin_details';

    $.ajax({
      url: url,
      method: 'GET',
      data: { email: email },
      dataType: 'json'
    }).done(function(json) {
      if (json.status !== 0 || !json.admin) {
        console.warn('Could not fetch admin details', json);
        return;
      }
      var admin = json.admin;

      // Update name
      $('#admin-name').text(admin.name || 'Admin');

      // Update avatar
      var $img = $('#admin-avatar-img');
      if (admin.profile_pic) {
        var src = admin.profile_pic.startsWith('http')
                  ? admin.profile_pic
                  : base + admin.profile_pic;
        $img.attr('src', src);
      } else {
        $img.attr('src', '{{ asset("assets/images/faces/face1.jpg") }}');
      }
    }).fail(function(xhr, status, err) {
      console.error('Admin details fetch error', status, err);
    });
  });
</script>

