{{-- resources/views/layouts/sidebar.blade.php --}}
<!-- partial:partials/_sidebar.html -->
@php
    if (session()->has('admin_token')) {
        $role = 'admin';
    } elseif (Auth::check()) {
        $role = Auth::user()->role; // 'user'
    } else {
        $role = null;
    }
@endphp
<nav class="sidebar sidebar-offcanvas" id="sidebar">
  <ul class="nav">
    <li class="nav-item nav-profile">
      <a href="#" class="nav-link">
        <div class="nav-profile-image">
          <img src="{{ asset('assets/images/faces/face1.jpg') }}" alt="profile" />
          <span class="login-status online"></span>
        </div>
        <div class="nav-profile-text d-flex flex-column">
          <span class="font-weight-bold mb-2">David Grey. H</span>
          <span class="text-secondary text-small">Project Manager</span>
        </div>
        <i class="mdi mdi-bookmark-check text-success nav-profile-badge"></i>
      </a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="{{ route('admin.dashboard') }}">
        <span class="menu-title">Dashboard</span>
        <i class="mdi mdi-home menu-icon"></i>
      </a>
    </li>
    <li class="nav-item">
      <a class="nav-link" data-bs-toggle="collapse"
         href="#ui-basic"
         aria-expanded="false"
         aria-controls="ui-basic">
        <span class="menu-title">Manage Subscriptions</span>
        <i class="menu-arrow"></i>
        <i class="mdi mdi-crosshairs-gps menu-icon"></i>
      </a>
      <!-- <div class="collapse" id="ui-basic">
        <ul class="nav flex-column sub-menu">
          <li class="nav-item">
            <a class="nav-link" href="{{ route('subscription.create') }}">Create Subscription</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.subscriptions') }}">Subscription plan List</a>
          </li>

         </ul>
      </div> -->
     
      <div class="collapse {{ request()->routeIs('subscription.*') ? 'show' : '' }}" id="ui-basic">
  <ul class="nav flex-column sub-menu">
  @if($role === 'admin')
    <li class="nav-item">
      @if(request()->routeIs('subscription.edit') && ($name = request()->route('plan_name')))
        <a class="nav-link {{ request()->routeIs('subscription.edit') ? 'active' : '' }}"
           href="{{ route('subscription.edit', ['plan_name' => $name]) }}">
          Edit Subscription
        </a>
      @else
        <a class="nav-link {{ request()->routeIs('subscription.create') ? 'active' : '' }}"
           href="{{ route('subscription.create') }}">
          Create Subscription
        </a>
      @endif
    </li>
    @endif
    <li class="nav-item">
      <a class="nav-link {{ request()->routeIs('admin.subscriptions') ? 'active' : '' }}"
         href="{{ route('admin.subscriptions') }}">
        Subscription plan List
      </a>
    </li>
    <li class="nav-item">
            <a class="nav-link" href="{{ route('subscription.users') }}">Subscribed User List</a>
          </li>
          @if($role === 'admin')     
    <li class="nav-item">
      <a class="nav-link" href="{{ route('admin.transactions') }}">Transactions</a>
            </li>  
          @endif    
  </ul>
</div>
    </li>

    @if($role === 'admin')
    <li class="nav-item">
      <a class="nav-link" data-bs-toggle="collapse"
         href="#tables"
         aria-expanded="false"
         aria-controls="tables">
        <span class="menu-title">Manage Trial</span>
        <!-- <i class="mdi mdi-table-large menu-icon"></i> -->
        <i class="fa-solid fa-hourglass-half menu-icon"></i>
      </a>
      <div class="collapse" id="tables">
        <ul class="nav flex-column sub-menu">
          <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.trial.form') }}">Set Trial Period</a>
          </li>
         </ul>
      </div>
    </li>
    @endif

    <li class="nav-item">
      <a class="nav-link" data-bs-toggle="collapse"
         href="#icons"
         aria-expanded="false"
         aria-controls="icons">
        <span class="menu-title">Speakers</span>
        <i class="mdi mdi-contacts menu-icon"></i>
      </a>
      <div class="collapse" id="icons">
        <ul class="nav flex-column sub-menu">
          <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.speakers') }}">Speaker Data</a>
          </li>
        </ul>
      </div>
    </li>
    <!-- <li class="nav-item">
      <a class="nav-link" data-bs-toggle="collapse"
         href="#forms"
         aria-expanded="false"
         aria-controls="forms">
        <span class="menu-title">Update Profile</span>
        <i class="mdi mdi-format-list-bulleted menu-icon"></i>
      </a> -->
      @if($role === 'admin')
      <li class="nav-item {{ request()->routeIs('admin.profile.edit') ? 'active' : '' }}">
  <a class="nav-link" data-bs-toggle="collapse"
     href="#forms"
     aria-expanded="{{ request()->routeIs('admin.profile.*') ? 'true' : 'false' }}"
     aria-controls="forms">
    <span class="menu-title">Update Admin Profile</span>
    <i class="mdi mdi-format-list-bulleted menu-icon"></i>
  </a>
      <!-- <div class="collapse" id="forms">
        <ul class="nav flex-column sub-menu">
          <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.profile.edit') }}">Admin Update Form</a>
          </li>
        </ul>
      </div> -->
      <div class="collapse {{ request()->routeIs('admin.profile.*') ? 'show' : '' }}" id="forms">
  <ul class="nav flex-column sub-menu">
    <li class="nav-item">
      <a class="nav-link {{ request()->routeIs('admin.profile.edit') ? 'active' : '' }}"
         href="{{ route('admin.profile.edit') }}">
        Admin Update Form
      </a>
    </li>
  </ul>
</div>
    </li>
    @endif
    
    <li class="nav-item">
      <a class="nav-link" data-bs-toggle="collapse"
         href="#charts"
         aria-expanded="false"
         aria-controls="charts">
        <span class="menu-title">Contact Support</span>
        <i class="mdi mdi-chart-bar menu-icon"></i>
      </a>
      <div class="collapse" id="charts">
        <ul class="nav flex-column sub-menu">
          <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.tickets') }}">Tickets</a>
          </li>
          @if($role === 'admin')
          <li class="nav-item">
            <a class="nav-link" href="{{ route('support.tickets') }}">Support Chat</a>
          </li>
          @endif
          <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.messages') }}">User Messages</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.notifications.all') }}">All Notifications</a>
          </li>
        </ul>
      </div>
    </li>

    @if($role === 'admin')
    <li class="nav-item">
      <a class="nav-link" data-bs-toggle="collapse"
         href="#tables"
         aria-expanded="false"
         aria-controls="tables">
        <span class="menu-title">Dashboard Users</span>
        <i class="mdi mdi-table-large menu-icon"></i>
      </a>
      <div class="collapse" id="tables">
        <ul class="nav flex-column sub-menu">
          <li class="nav-item">
            <a class="nav-link" href="{{ route('users.index') }}">User List</a>
          </li>
          <!-- <li class="nav-item">
            <a class="nav-link" href="{{ route('users.create') }}">Create Dashboard User</a>
          </li> -->
          <li class="nav-item">
      @if(request()->routeIs('users.edit') && ($id = request()->route('dashboard_user')))
        <a class="nav-link {{ request()->routeIs('subscription.edit') ? 'active' : '' }}"
           href="{{ route('users.edit', ['dashboard_user' => $id]) }}">
          Edit Dashboard User
        </a>
      @else
        <a class="nav-link {{ request()->routeIs('users.create') ? 'active' : '' }}"
           href="{{ route('users.create') }}">
          Create Dashboard User
        </a>
      @endif
    </li> 
        </ul>
      </div>
    </li>

    @endif

    <li class="nav-item">
      <a class="nav-link" data-bs-toggle="collapse"
         href="#tables"
         aria-expanded="false"
         aria-controls="tables">
        <span class="menu-title">App Users</span>
        <i class="mdi mdi-table-large menu-icon"></i>
      </a>
      <div class="collapse" id="tables">
        <ul class="nav flex-column sub-menu">
          <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.users') }}">User Data</a>
          </li>
          @if($role === 'admin')
          <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.users.blocked') }}">Blocked User Data</a>
          </li>
          @endif
        </ul>
      </div>
    </li>
    
    <li class="nav-item">
      <a class="nav-link" href="{{ route('admin.documentation') }}" target="_blank">
        <span class="menu-title">Documentation</span>
        <i class="mdi mdi-file-document-box menu-icon"></i>
      </a>
    </li>
  </ul>
</nav>
{{-- end of sidebar partial --}} 

<style>

.sidebar .nav .nav-item.active > .nav-link .menu-title {
    color: #0041C2;
   }

   .sidebar .nav .nav-item.active > .nav-link i {
    color: #0041C2;
}

.sidebar .nav.sub-menu .nav-item .nav-link.active {
    color: #0041C2;
   
}



  </style>
