<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AdminController;
use App\Http\Controllers\AdminAuthController;
use App\Http\Middleware\AdminAuth;
use App\Http\Controllers\AdminUserController;
use App\Http\Controllers\AdminSpeakerController;
use App\Http\Controllers\AdminSupportController;
use App\Http\Controllers\AdminDocumentationController;
use App\Http\Controllers\SubscriptionPlanController;
use App\Http\Controllers\AdminSettingsController;
use App\Http\Controllers\AdminDashboardUserController;

// Route::get('/', function () {
//     return view('welcome');
// });



//Route::get('/dashboard',  [AdminController::class, 'index'])->name('dashboard'); 


Route::get('/', [AdminAuthController::class,'showLoginForm'])
->name('login.form'); 
   

Route::post('admin/login', [AdminAuthController::class,'login'])
->name('admin.login');  


Route::prefix('admin')
     ->group(function () {
         Route::get('dashboard', [AdminController::class, 'index'])
              ->name('admin.dashboard');
        Route::post('logout', [AdminAuthController::class,'logout'])
              ->name('admin.logout');  
    Route::get('users', [AdminUserController::class, 'index'])
              ->name('admin.users'); 
              
    Route::get('speakers', [AdminSpeakerController::class, 'index'])
              ->name('admin.speakers');  
Route::post('users/delete', [AdminUserController::class, 'destroy'])
 ->name('admin.users.destroy');  
 
 Route::get('profile/edit-form', [AdminAuthController::class, 'showProfileForm'])
              ->name('admin.profile.edit')->middleware(AdminAuth::class);

Route::post('profile/edit', [AdminAuthController::class, 'updateProfile'])
              ->name('admin.profile.update')->middleware(AdminAuth::class);  
              
Route::get('tickets', [AdminSupportController::class, 'index'])
              ->name('admin.tickets');  
              
Route::get('support-tickets', [AdminSupportController::class, 'show'])
              ->name('support.tickets')->middleware(AdminAuth::class);

         
Route::get('tickets/{userEmail}', [AdminSupportController::class, 'chat'])
              ->name('admin.tickets.chat')->middleware(AdminAuth::class);

        
Route::post('tickets/{userEmail}', [AdminSupportController::class, 'send'])
              ->name('admin.tickets.send')->middleware(AdminAuth::class); 
              
Route::get('notifications', [AdminSupportController::class, 'allNotifications'])
              ->name('admin.notifications.all');  

Route::get('messages', [AdminSupportController::class, 'allMessages'])
              ->name('admin.messages');

 Route::get('/users/blocked', [AdminUserController::class, 'blocked'])
         ->name('admin.users.blocked');

Route::post('/users/unblock', [AdminUserController::class, 'unblock'])
         ->name('admin.users.unblock')->middleware(AdminAuth::class); 
         
Route::get('/documentation', [AdminDocumentationController::class, 'index'])
         ->name('admin.documentation') ; 
         
Route::get('subscriptions/manage', [SubscriptionPlanController::class, 'create'])
         ->name('subscription.create')->middleware(AdminAuth::class);

    
Route::post('subscriptions/manage', [SubscriptionPlanController::class, 'store'])
         ->name('subscription.store')->middleware(AdminAuth::class);  

Route::get('subscriptions', [SubscriptionPlanController::class, 'index'])
         ->name('admin.subscriptions');

Route::get  ('subscriptions/{plan_name}/edit', [SubscriptionPlanController::class,'edit'])->name('subscription.edit')->where('plan_name', '.*')->middleware(AdminAuth::class);
Route::post ('subscriptions/{plan_name}',[SubscriptionPlanController::class,'update'])->name('subscription.update')->middleware(AdminAuth::class);
Route::delete('subscriptions/{plan_name}',[SubscriptionPlanController::class,'destroy'])->name('subscription.destroy')->middleware(AdminAuth::class);  

Route::get('subscriptions/users_list', [SubscriptionPlanController::class, 'subscribedUsers'])
     ->name('subscription.users');

Route::get('transactions', [SubscriptionPlanController::class, 'transactions'])
     ->name('admin.transactions')->middleware(AdminAuth::class);

Route::get('trial', [AdminSettingsController::class, 'showTrialForm'])
     ->name('admin.trial.form')->middleware(AdminAuth::class);

Route::post('trial', [AdminSettingsController::class, 'setTrial'])
     ->name('admin.trial.set')->middleware(AdminAuth::class);   
     
Route::resource('dashboard-users', AdminDashboardUserController::class)
     ->names(['index'=>'users.index','create'=>'users.create','store'=>'users.store',
              'edit'=>'users.edit','update'=>'users.update'])->middleware(AdminAuth::class); 
Route::delete('dashboard-users/{user}',     [AdminDashboardUserController::class,'destroy'])->name('users.destroy')->middleware(AdminAuth::class);    
              
     });


       
